<?php
namespace app\index\controller;
use think\Controller;
use think\Db;
use think\Cache;
use think\Session;
use think\Request;

class Pay extends Controller
{   
	//商户ID（商户编号）
	private $appid="填写商户ID";
	
	//商户密钥
	private $appkey="填写商户密钥";
	
	//异步通知地址
	private $notify_url="http://你的网站域名/Index/Pay/paynotify.html";
	//服务器异步通知页面路径  需http://格式的完整路径，不能加?id=123这类自定义参数，必须外网可以正常访问
	
	private $return_url="http://你的网站域名/Index/Pay/payreturn.html";
	//页面跳转同步通知页面路径 需http://格式的完整路径，不能加?id=123这类自定义参数，必须外网可以正常访问

	//聚合支付POST提交地址
	$payurl="https://www.37yz.com/pay.html";
	
	//聚合支付提交页面
	public function index(){		
		if(request()->isPost()){
			$data=input('post.');
			/** 
			 *	防止POST重复提交，下面的情况会导致表单重复提交：
				1.点击提交按钮两次。
				2.点击刷新按钮。
				3.使用浏览器后退按钮重复之前的操作，导致重复提交表单。
				4.使用浏览器历史记录重复提交表单。
				5.浏览器重复的HTTP请求。
				6.网页被恶意刷新。
				(session('code')==$data['code']) && $this->error('不能重复提交数据!');
				session('code',$data['code']);
			*/			
			!isset($data['payid']) && $this->error('订单号不能为空');
			!isset($data['money']) && $this->error('充值金额不能为空');
			empty(trim($data['payid'])) && $this->error('订单号不能为空');
			empty(trim($data['money'])) && $this->error('充值金额不能为空');						
			//3.计算签名
			$payid=trim($data['payid']);//订单号
			$money=trim($data['money']);//提交金额
			$type=trim($data['type']);//支付方式 1：支付宝  2：微信支付 3：QQ钱包	
			$subject = trim($data['subject']);//商品名称（选填）
			$urlData=array(
				"appid" => $appid,
				"payid" => $payid,
				"money" => $money,
				"type" => $type,
				"notify_url" => $notify_url,
				"return_url" => $return_url,
				"subject" => $subject
			);
			$stringTemp=$this->ASCII($urlData);
			$sign=md5($stringTemp . $appkey);
			$urlData["sign"] =	$sign;
			//4.跳转到支付页面
			$res = $this->buildRequestForm($payurl,$urlData);
			echo $res;
			exit;
		}else{
			//生成不重复的订单号
			$payid=$this-> generateOrderNumber();
			$this->assign('payid',$payid);
			return view();
		}
	}
	//异步通知地址
	public function paynotify(){
		if (empty($_POST)) $_POST = $_GET;       //如果为GET方式访问
		$sign = $this->ASCII($_POST);
		$pay_id = $_POST['pay_id'];              //需要充值的ID 或订单号 或用户名
		$pay_money = (float)$_POST['pay_money']; //实际付款金额
		$pay_no = $_POST['pay_no'];              //交易流水号
		$pay_time = $_POST['pay_time'];	         //付款的时间戳			
		$pay_type = (int)$_POST['pay_type']; 	 //支付方式 1：支付宝 2：微信支付 3：QQ钱包	
		$param = isset($_POST['param'])?$_POST['param']:'';//自定义参数	
		if (!$_POST['pay_no'] || md5($sign . $appkey) != $_POST['sign']) { //不合法的数据
			exit('fail');    //返回失败 继续补单
		} else { //合法的数据
			/**
			 * 业务处理在这里写
			 */				
			exit('success'); //返回成功，业务处理完成，下面不再执行了	
		}
	}
	//同步通知地址
	public function payreturn(){
		if (empty($_POST)) $_POST = $_GET;       //如果为GET方式访问
		$sign = $this->ASCII($_POST);
		$pay_id = $_POST['pay_id'];              //需要充值的ID 或订单号 或用户名
		$pay_money = (float)$_POST['pay_money']; //实际付款金额
		$pay_no = $_POST['pay_no'];              //交易流水号
		$pay_time = $_POST['pay_time'];	         //付款的时间戳			
		$pay_type = (int)$_POST['pay_type']; 	 //支付方式 1：支付宝  2：微信支付 3：QQ钱包	
		$param = isset($_POST['param'])?$_POST['param']:'';//自定义参数
		if (!$_POST['pay_no'] || md5($sign . $appkey) != $_POST['sign']) { //不合法的数据
			$result = '支付失败';
		} else { //合法的数据
			/**
			 * 业务处理在这里写
			 */
			$result = '支付成功';
		}
		$this->assign('pay_id',$pay_id);
		$this->assign('pay_no',$pay_no);
		$this->assign('pay_money',$pay_money);
		$this->assign('pay_type',$pay_type);
		$this->assign('pay_time',date("Y-m-d H:i:s",$pay_time));
		$this->assign('param',$param);
		$this->assign('result',$result);
		return view();
	}
	
	/**
	 * 生成订单号
	 */
	 protected function generateOrderNumber($length=4){
		$date=trim(date('Ymdhis ',time()));
		$number=trim($this->getRandNumber($length));
		return $date.$number;
	 }
	/**
	*生成不重复的随机数字
	*@paramint$start需要生成的数字开始范围
	*@paramint$end结束范围
	*@paramint$length需要生成的随机数个数
	*@returnnumber生成的随机数
	*/
	protected function getRandNumber($length=4){
		//初始化变量为0
		$connt = 0;
		//建一个新数组
		$temp = array();
		while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中	
		$connt = count($data);
		}
		//为数组赋予新的键名
		shuffle($data);
		//数组转字符串
		$str=implode(",", $data);
		//替换掉逗号
		$number=str_replace(',', '', $str);
		return $number;
	}
	/* 1.将数组内非空参数值的参数按照参数名从小到大排序（ASCII码字典序）
	 * 2.然后使URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串
	 */
	function ASCII($params = array()){
		//ksort()对数组按照键名进行升序排序
		ksort($params);
		//reset()内部指针指向数组中的第一个元素
		reset($params);
		//$sign = http_build_query($params, '', '&amp');
		$sign = '';//初始化
		foreach ($params AS $key => $val) { //遍历POST参数
			if ($val == ''||$key == 'sign') continue; //跳过这些不签名
			if ($sign) $sign .= '&'; //第一个字符串签名不加& 其他加&连接起来参数
			$sign .= "$key=$val"; //拼接为url参数形式
		}		
		return $sign;
	}
	/**
	 * 建立跳转请求表单
	 * @param string $url 数据提交跳转到的URL
	 * @param array $data 请求参数数组
	 * @param string $method 提交方式：post或get 默认post
	 * @return string 提交表单的HTML文本
	 */
	function buildRequestForm($url, $data, $method = 'post')
	{
		$sHtml = "<form id='requestForm' name='requestForm' action='".$url."' method='".$method."'>";
		while (list ($key, $val) = each ($data))
		{
			$sHtml.= "<input type='hidden' name='".$key."' value='".$val."' />";
		}
		$sHtml = $sHtml."<input type='submit' value='正在跳转到支付'></form>";
		$sHtml = $sHtml."<script>document.forms['requestForm'].submit();</script>";
		return $sHtml;
	}		
}
?>
