﻿<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title>聚合支付测试 - 三七云</title>
</head>
<?php
/**
 * 三七云 https://37yz.com/
 * 功能：即时到账交易接口接入页
 * 版本：1.0
 * 日期：2020-01-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
 */
date_default_timezone_set("Asia/Shanghai");
require_once("pay_config.php");
require_once("lib/pay_submit.class.php");

/**************************请求参数**************************/

		
//商户订单号（商户网站订单系统中唯一订单号，必填）
$payid = generateOrderNumber();
//支付方式（必填）
$type = $_POST['type'];
//商品名称（选填）
$subject = $_POST['subject'];
//付款金额（必填）
$money = $_POST['money'];
/************************************************************/

//1.构造要请求的参数数组，无需改动
$parameter = array(		
	"appid" => $pay_config['appid'],
	"notify_url" => $pay_config['notify_url'],
	"return_url" => $pay_config['return_url'],
	"money" => $money,
	"payid" => $payid,
	"type" => $type,
	"subject" => $subject
);

//2.建立请求
$paySubmit = new PaySubmit($pay_config);
$html_text = $paySubmit->buildRequestForm($parameter);
echo $html_text;

/**
 * 生成18位订单号
 * $length：随机数长度
 */
function generateOrderNumber($length=4){
	//14位的日期（年月日时分秒）
	$date=trim(date('Ymdhis ',time()));
	//初始化变量为0
	$connt = 0;
	//建一个新数组
	$temp = array();
	while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中	
		$connt = count($data);
	}
	//为数组赋予新的键名
	shuffle($data);
	//数组转字符串
	$str=implode(",", $data);
	//替换掉逗号
	$number=str_replace(',', '', $str);
	return $date.$number;
}
?>
</body>
</html>