<%@ page language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@ page import="java.util.*"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ include file="lib/pay_notify.jsp"%>
<%
 /**
 * 三七云 https://37yz.com/
 * 功能：页面跳转同步通知页面
 * 版本：1.0
 * 日期：2020-01-01
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
 */
 
/**
 ***********************************************页面功能说明**********************************************
 * 该页面可在本机电脑测试。
 * 可放入HTML等美化页面的代码、商户业务逻辑程序代码。
 * 该页面可以使用Java开发工具调试，也可以使用Log日志调试
 * 调用日志示例：
   //引入Log类，位于：lib/Log.jsp
   Log log=new Log()
   log.info("日志内容");
  *********************************************************************************************************
 */

/**
 * 设置编码（放在jsp页面最顶部）
 */
request.setCharacterEncoding("utf-8");
response.setCharacterEncoding("utf-8");
response.setContentType("text/html;charset=UTF-8");

//申明hashMap变量储存接收到的参数名用于排序
Map<String,String> params = new HashMap<String,String>(); 
//获取请求的全部参数
Map requestParams = request.getParameterMap(); 
for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
	String key = (String) iter.next();
	String[] values = (String[]) requestParams.get(key);
	String valueStr = values[0];
	//乱码解决，这段代码在出现乱码时使用。如果sign不相等也可以使用这段代码转化
	//valueStr = new String(valueStr.getBytes("utf-8"), "gbk");
	params.put(key, valueStr);//增加到params保存
}
//计算得出通知验证结果
PayNotify payNotify = new PayNotify();
boolean verifyResult = payNotify.verify(params);
//定义默认参数
SimpleDateFormat sdf =  new SimpleDateFormat ("yyyy-MM-dd HH:mm:ss");
String pay_id="";
double pay_money=0;
String pay_no="";
String pay_time=sdf.format(new Date());
String param="";
String typeName="";
String result="";
if(verifyResult) {//验证成功
	////////////////////////////请根据您的业务逻辑来编写程序（以下代码仅作参考）////////////////////////////////
	
    //获取接口的通知返回参数（可参考技术文档中服务器异步通知参数列表）	
	pay_id    = request.getParameter("pay_id");                       //需要充值的ID或订单号或用户名
	pay_money = Double.parseDouble(request.getParameter("pay_money"));//实际付款金额
	pay_no    = request.getParameter("pay_no");                       //交易流水号
	String temptime  = request.getParameter("pay_time");              //付款的时间戳
	String pay_type  = request.getParameter("pay_type");  //支付方式1：支付宝 2：微信支付 3：QQ钱包
	param     = (request.getParameter("param")!=null)?request.getParameter("param"):""; //自定义参数
	//日期转换
	long long_time=Long.parseLong(temptime)*1000;//当前时间戳为10位，所以需要乘以1000
	pay_time=sdf.format(new Date(long_time));
	//支付类型
	switch (Integer.parseInt(pay_type)) {
		case 1:
			typeName = "支付宝";
			break;
		case 2:
			typeName = "微信支付";
			break;
		case 3:
			typeName = "QQ钱包";
			break;
	}
	if(pay_no!=null&pay_no.length()!=0){//合法的数据
		/*
		 * 在这里执行您网站的业务逻辑
		 * 提示：
		 * 1.判断该笔订单是否在商户网站中已经做过处理
		 * 2.如果没有做过处理，根据订单号（pay_id）在商户网站的订单系统中查到该笔订单的详细，并执行商户的业务程序
		 * 3.如果有做过处理，不执行商户的业务程序
		 * 4.注意：付款完成后，支付平台系统发送该交易状态通知
		*/
    }	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	result="支付成功";
}else{
	//验证失败
    //如要调试，请看lib/pay_notify.jsp页面的verify函数
    result="支付失败";
}
%>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=no">
		<title>即时到账交易接口 - 三七云</title>
		<meta name="keywords" content="聚合支付,移动支付,免签支付,轮询支付,聚合移动支付,三方支付,第三方支付,四方支付,第四方支付,微信支付,支付宝支付,银联支付,京东支付,跨境支付,QQ钱包支付,刷脸支付,收银台,一码付,聚合码,聚合码支付,扫码支付,当面付,支付宝代付,微信代付,企业付款到零钱,转账到支付宝,现金红包">
		<meta name="description" content="三七云-移动支付技术服务商，让支付简单、专业、快捷！">
		<style type="text/css">
			*{padding:0;margin:0;}
			li{ list-style-type:none; }			
			fieldset{border: 1px solid #ccc;color: #666;padding: 10px;margin: 10px;}
		</style>
	</head>
	<body>
		<h3 style="text-align: center;"><%= result %></h3>
		<fieldset>
	    <legend>订单详情</legend>
		<ul>
			<li>唯一标识：<%= pay_id %></li>
			<li>流水编号：<%= pay_no %></li>
			<li>实付金额：<%= pay_money %></li>		
			<li>支付方式：<%= typeName %></li>
			<li>付款时间：<%= pay_time %></li>
			<li>自定义参数：<%= param %></li>
			<li>状态：<%= result %></li>
		</ul>
		</fieldset>
	</body>
 
</html>