<?php

class yuanbaopay_plugin
{
	static public $info = [
		'name'        => 'yuanbaopay', //支付插件英文名称，需和目录名称一致，不能有重复
		'showname'    => '三七云(37yz.com)', //支付插件显示名称
		'author'      => '三七(QQ：79899080)', //支付插件作者
		'link'        => 'https://www.37yz.com/', //支付插件作者链接
		'types'       => ['alipay','wxpay','qqpay'], //支付插件支持的支付方式
		'inputs' => [ //支付插件要求传入的参数以及参数显示名称
			'appurl' => [
				'name' => '网站地址',
				'type' => 'input',
				'note' => '必须以http://或https://开头，以/结尾',
			],
			'appid' => [
				'name' => '商户编号',
				'type' => 'input',
				'note' => '',
			],
			'appkey' => [
				'name' => '商户密钥',
				'type' => 'input',
				'note' => '',
			],
		],
		'select' => null,
		'note' => '', //支付密钥填写说明
		'bindwxmp' => false, //是否支持绑定微信公众号
		'bindwxa' => false, //是否支持绑定微信小程序
	];
	static public function submit(){
		global $channel, $order;
		if($order['typename']=='alipay'){
			return self::alipay();
		}elseif($order['typename']=='wxpay'){
			if(checkwechat() && in_array('6',$channel['apptype'])){
				return ['type'=>'jump','url'=>'/pay/wxjspay/'.TRADE_NO.'/?d=1'];
			}else{
				return self::wxpay();
			}
		}
	}
	//通用下单
	static private function addOrder($type){
		global $channel, $order, $ordername, $conf, $clientip, $siteurl, $device;
		require(PAY_ROOT."inc/yuanbao.config.php");
		require(PAY_ROOT."inc/YuanbaoCore.class.php");
		$parameter = array(
			"appid" => trim($yuanbao_config['pid']),
			"payid" => TRADE_NO,
			"money" => (float)$order['realmoney'],
			"type" => $type,
			"notify_url" => $conf['localurl'].'pay/notify/'.TRADE_NO.'/',
			"return_url" => $siteurl.'pay/return/'.TRADE_NO.'/',
			"subject" => $order['name']
		);
		//建立请求
		$payobj = new YuanbaoCore($yuanbao_config);	
		$returnData = $payobj->dopay($parameter);
		if($returnData['status']==1){
			if(isset( $returnData['code_url']) && !empty($returnData['code_url'])){
			    $qrcode = $returnData['code_url'];//二维码链接
			}else{
			    $qrcode = $returnData['pay_url'];//支付链接
			}
			return ['qrcode', $qrcode];
		}else{
			return ['type'=>'error','msg'=>'支付下单失败'];
		}
	}
	//支付宝扫码支付
	static public function alipay(){
		try{
			list($type, $url) =  self::addOrder(1);
		}catch(Exception $ex){
			return ['type'=>'error','msg'=>'支付宝支付下单失败！'.$ex->getMessage()];
		}
		if($type == 'redirect_url'){
			return ['type'=>'jump','url'=>$url];
		}elseif($type == 'form'){
			return ['type'=>'form','url'=>$url];
		}else{
			return ['type'=>'qrcode','page'=>'alipay_qrcode','url'=>$url];
		}
	}

	//微信扫码支付
	static public function wxpay(){
		try{
			list($type, $url) = self::addOrder(2);
		}catch(Exception $ex){
			return ['type'=>'error','msg'=>'微信支付下单失败！'.$ex->getMessage()];
		}
		if($type == 'redirect_url'){
			return ['type'=>'jump','url'=>$url];
		}elseif($type == 'form'){
			return ['type'=>'form','url'=>$url];
		}else{
			
			return ['type'=>'qrcode','page'=>'wxpay_qrcode','url'=>$url];
			
		}
	}
	//异步回调
	static public function notify(){
		global $order;
		require(PAY_ROOT."inc/yuanbao.config.php");
		require(PAY_ROOT."inc/YuanbaoCore.class.php");
		if (empty($_POST)) $_POST = $_GET;//如果为GET方式访问
		//计算得出通知验证结果
		$payobj = new YuanbaoCore($yuanbao_config);
		$verify_result = $payobj->verifyNotify();

		if($verify_result) {//验证成功
			//商户订单号
			$out_trade_no = $_POST['pay_id'];
			//交易流水号
			$api_trade_no = $_POST['pay_no'];
			//交易金额
			$money = $_POST['pay_money'];
			if($out_trade_no == TRADE_NO){
				processNotify($order, $api_trade_no);
			}
			return ['type'=>'html','data'=>'success'];
		}
		else {
			//验证失败
			return ['type'=>'html','data'=>'fail'];
		}
	}

	//同步回调
	static public function return(){
		global $order;
		require(PAY_ROOT."inc/yuanbao.config.php");
		require(PAY_ROOT."inc/YuanbaoCore.class.php");

		//计算得出通知验证结果
		$payobj = new YuanbaoCore($yuanbao_config);
		$verify_result = $payobj->verifyReturn();
		if($verify_result) {
			//商户订单号
			$out_trade_no = $_POST['pay_id'];
			//交易流水号
			$api_trade_no = $_POST['pay_no'];
			//交易金额
			$money = $_POST['pay_money'];
			if ($out_trade_no == TRADE_NO) {
				processReturn($order, $api_trade_no);
			}else{
				return ['type'=>'error','msg'=>'订单信息校验失败'];
			}
		}
		else {
			//验证失败
			return ['type'=>'error','msg'=>'验证失败！'];
		}
	}

}