<?php
/* *
 * 三七云SDK服务类
 * 说明：
 * 包含发起支付、查询订单、回调验证等功能
 */

class YuanbaoCore
{
	private $pid;
	private $key;
	private $submit_url;
	private $api_url;

	function __construct($config){
		$this->pid = $config['pid'];
		$this->key = $config['key'];
		$this->submit_url = $config['apiurl'].'pay.html';
		$this->api_url = $config['apiurl'].'pay/query.html';
	}
	// 发起支付
	public function dopay($params){
		$params ["native"] = true;
		//生成签名
        $params["sign"] = $this->generateSign($params,$this->key);
		$response = $this->curl_post($this->submit_url,$params);
		$returnData = json_decode($response, true);
		return $returnData;
		
	}
	// 异步回调验证
	public function verifyNotify(){
		if(empty($_GET)) return false;

		$sign = $this->getSign($_GET);

		if($sign === $_GET['sign']){
			$signResult = true;
		}else{
			$signResult = false;
		}

		return $signResult;
	}

	// 同步回调验证
	public function verifyReturn(){
		if(empty($_GET)) return false;

		$sign = $this->getSign($_GET);

		if($sign === $_GET['sign']){
			$signResult = true;
		}else{
			$signResult = false;
		}

		return $signResult;
	}

	// 查询订单支付状态
	public function orderStatus($trade_no){
		$result = $this->queryOrder($trade_no);
		if(isset($result['code']) && $result['code']==1){
			return true;
		}else{
			return false;
		}
	}

	// 查询订单
	public function queryOrder($trade_no){
		$data=array(
			"appid" => $this->pid,
			"pay_id"  => $trade_no//商户订单号
		);
		//生成签名
        $data["sign"] = $this->generateSign($data,$this->key);
		$response = $this->curl_post($url,$data);
		$arr = json_decode($response, true);
		return $arr;
	}

	private function generateSign($params,$appkey) {
       //ksort()对数组按照键名进行升序排序
		ksort($params);
		//reset()内部指针指向数组中的第一个元素
		reset($params);
		//$sign = http_build_query($params, '', '&amp');
		$sign = ''; //初始化
		foreach ($params AS $key => $val) { //遍历POST参数
			if ($val == '' || $key == 'sign' || $key == 'signArray'|| $key == '__token__'||$key=='encrypt'||$key=='charset') continue; //跳过这些不签名
			if ($sign) $sign.= '&'; //第一个字符串签名不加& 其他加&连接起来参数
			$sign.= "$key=$val"; //拼接为url参数形式      
		}
		//拼接商户密钥，然后md5加密
		$stringTemp = md5($sign.$appkey);
		//转为小写
		return strtolower($stringTemp);
    }
	/**
	 * curl发送post请求
	 * @param url       请求地址
	 * @param postData  要传递的post数据
	 */
	private function curl_post($url, $postdata) {
		//启动一个CURL会话
		$ch = curl_init();
		// 设置curl允许执行的最长秒数
		curl_setopt($ch, CURLOPT_TIMEOUT, $this->timeOut);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
		// 获取的信息以文件流的形式返回，而不是直接输出。
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
        //发送一个常规的POST请求。
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_URL, $url);
        //要传送的所有数据
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
		// 执行操作
		$res = curl_exec($ch);
		$this->responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		if ($res == NULL) { 
		   $this->error = "call http err :" . curl_errno($ch) . " - " . curl_error($ch) ;
		   curl_close($ch);
		   return null;
		} else if($this->responseCode  != "200") {
			$this->error = "call http err httpcode=" . $this->responseCode  ;
			curl_close($ch);
			return null;
		}
		curl_close($ch);
		return $res;
	}
}
