﻿<!--#include file="lib/pay_notify.class.asp"-->
<%
'/**
' * 三七云 https://37yz.com/
' * 功能：页面跳转同步通知页面
' * 版本：1.0
' * 日期：2020-01-01
' * 说明：
' * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
' * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
' */

'/**
' ***********************************************页面功能说明**********************************************
' * 该页面可在本机电脑测试。
' * 可放入HTML等美化页面的代码、商户业务逻辑程序代码。
' * 该页面可以使用开发工具调试，也可以使用文本函数logResult("日志信息")打印日志。
'  *********************************************************************************************************
' */

'计算得出通知验证结果
Set objNotify = New PayNotify
sVerifyResult = objNotify.Verify()
If sVerifyResult Then	'验证成功

	'////////////////////////////请根据您的业务逻辑来编写程序（以下代码仅作参考）////////////////////////////////
	
    '//获取接口的通知返回参数（可参考技术文档中服务器异步通知参数列表）	
	pay_id    = Request.Form("pay_id")       '//需要充值的ID或订单号或用户名
	pay_money = Request.Form("pay_money")	 '//实际付款金额
	pay_no    = Request.Form("pay_no")       '//交易流水号
	pay_time  = Request.Form("pay_time")     '//付款的时间戳
	pay_type  = Request.Form("pay_type")     '//支付方式1：支付宝 2：微信支付 3：QQ钱包
	'//自定义参数
	If Request.Form("param") <> "" Then
		param = Request.Form("param")
	Else
		param = ""
	End If
	
	Dim typeName
	Select Case pay_type
	 Case "1"
	   typeName = "支付宝"
	 Case "2"
	   typeName = "微信支付"
	 Case Else 
	   typeName = "QQ钱包"
	End Select

	If Request.Form("pay_no") <> "" Then '//合法的数据
		'/*
		' * 在这里执行您网站的业务逻辑
		' * 提示：
		' * 1.判断该笔订单是否在商户网站中已经做过处理
		' * 2.如果没有做过处理，根据订单号（pay_id）在商户网站的订单系统中查到该笔订单的详细，并执行商户的业务程序
		' * 3.如果有做过处理，不执行商户的业务程序
		' * 4.注意：付款完成后，支付平台系统发送该交易状态通知
		'*/
		result="支付成功"

	End If
else 
	'验证失败
	'//如要调试，请看lib/pay_notify.class.asp页面的verify函数
	pay_id=""
	pay_money=0
	pay_no=""
	pay_time=Now()
	param=""
	typeName=""  
    result="支付失败"
end if
%>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
		<meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=no">
		<title>即时到账交易接口 - 三七云</title>
		<meta name="keywords" content="聚合支付,移动支付,免签支付,轮询支付,聚合移动支付,三方支付,第三方支付,四方支付,第四方支付,微信支付,支付宝支付,银联支付,京东支付,跨境支付,QQ钱包支付,刷脸支付,收银台,一码付,聚合码,聚合码支付,扫码支付,当面付,支付宝代付,微信代付,企业付款到零钱,转账到支付宝,现金红包">
		<meta name="description" content="三七云-移动支付技术服务商，让支付简单、专业、快捷！">
		<style type="text/css">
			*{padding:0;margin:0;}
			li{ list-style-type:none; }			
			fieldset{border: 1px solid #ccc;color: #666;padding: 10px;margin: 10px;}
		</style>
	</head>
	<body>
		<h3 style="text-align: center;"><%= result %></h3>
		<fieldset>
	    <legend>订单详情</legend>
		<ul>
			<li>唯一标识：<%= pay_id %></li>
			<li>流水编号：<%= pay_no %></li>
			<li>实付金额：<%= pay_money %></li>			
			<li>支付方式：<%= typeName %></li>
			<li>付款时间：<%= FormatDate(pay_time,1) %></li>
			<li>自定义参数：<%= param %></li>
			<li>状态：<%= result %></li>
		</ul>
		</fieldset>
	</body>
 
</html>