<?php
date_default_timezone_set("PRC");
error_reporting(E_ALL ^ E_DEPRECATED);
header("Content-Type: text/html;charset=utf-8");
 /**
 * 三七云 https://37yz.com/
 * 功能：接口配置文件
 * 版本：1.0
 * 日期：2024-06-05
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
 */
 
//↓↓↓↓↓↓↓↓↓↓请在这里配置您的基本信息↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
$payurl = 'https://www.37yz.com/pay.html'; //聚合支付POST提交地址
$appid = '填写商户编号'; //商户编号
$appkey = '填写商户密钥'; //商户密钥
$notify_url = 'http://网站域名:82/pay/notify.php'; //异步通知地址
$return_url = 'http://网站域名:82/pay/return.php'; //同步跳转页面

//修改数据库连接信息
$db_ip = "127.0.0.1"; //数据库地址
$db_name = "root"; //数据库用户
$db_psd = "123456"; //数据库密码
$server = "moyu_game";//数据库名称

$quarr = array(
    "1" => array(
        "name" => "1区",
        "url" => "http://127.0.0.1:10061",
        "platformId" => 3006,
        "serverID" => 32801,
        "zs" => "3#10000"  //入群福利配置 格式：物品ID#数量
    ),
    "2" => array(
        "name" => "2区",
        "url" => "http://127.0.0.1:10062",
        "platformId" => 3006,
        "serverID" => 32802,
        "zs" => "3#10000"  //入群福利配置 格式：物品ID#数量
    ),
    "3" => array(
        "name" => "4区",
        "url" => "http://127.0.0.1:10063",
        "platformId" => 3006,
        "serverID" => 32803,
        "zs" => "3#10000"  //入群福利配置 格式：物品ID#数量
    ),
    "4" => array(
        "name" => "4区",
        "url" => "http://127.0.0.1:10064",
        "platformId" => 3006,
        "serverID" => 32804,
        "zs" => "3#10000"  //入群福利配置 格式：物品ID#数量
    ),
);

$goods = array(
    array(
        "amount" => 10, //售价，不要有重复
        "name" => "10元礼包", //名称
        "goods" => "3#1200000;624#1200000" //格式：物品ID#数量
    ),	
        array(
        "amount" => 30, //售价，不要有重复
        "name" => "30礼包", //名称
        "goods" => "86#2;7#99999999;9#99999999;30130003#999999;30140003#999999;30080002#9999;30080017#9999;30160002#99999;60010#14;60060#14;60040#14;60050#14;60120#14;32200012#999999;32200013#999999;9028#500;700510#30000;70400001#99999;26090005#1;32200024#300" //格式：物品ID#数量
    ),
    array(
        "amount" => 50, //售价，不要有重复
        "name" => "50元礼包", //名称
        "goods" => "3#20000000;624#20000000" //格式：物品ID#数量
    ),    array(
        "amount" => 100, //售价，不要有重复
        "name" => "100元礼包", //名称
        "goods" => "3#110000000;624#110000000" //格式：物品ID#数量
    ),
    array(
        "amount" => 200, //售价，不要有重复
        "name" => "200礼包", //名称
        "goods" => "3#240000000;624#240000000" //格式：物品ID#数量
    ),
);

function getRoleIDByName($apiUrl, $roleName) {
    $apiUrl = $apiUrl.
    "/role/name";
    $param = array(
        "name" => $roleName,
    );
    $sign = calcSign($param);
    $param["sign"] = $sign;
    $ret = sendPost($apiUrl, $param);
    $retData = json_decode($ret, true, 512, JSON_BIGINT_AS_STRING);
    $status = $retData["status"];
    if ($status != 200) {
        return 0;
    }
    $roleid = $retData["data"]["id"];
    return $roleid;
}

function webRecharge($apiUrl, $param) {
    $apiUrl = $apiUrl.
    "/webRecharge";
    $retData = json_decode(sendPost($apiUrl, $param), true);
    return true;
}

function generalOrderID() {
    $order_id_main = date('Ymd');
    $order_id_len = strlen($order_id_main);
    $order_id_sum = 0;
    for ($i = 0; $i < $order_id_len; $i++) {
        $order_id_sum += (int)(substr($order_id_main, $i, 1));
    }
    $pro = substr(md5(uniqid(microtime(true).mt_rand())), 0, 3);
    $orderid = $order_id_main.str_pad((100 - $order_id_sum % 100) % 100, 2, '0', STR_PAD_LEFT).$pro;
    return $orderid;
}

function calcRechargeSign($inArray) {
    $preStr = implode("", $inArray).
    "k0RlsOyyWMoi";
    return sha1($preStr);
}

function sendPost($url, $param) {
    $gmusername = "shenghe";
    $gmpassword = "kgiVYEh7pKu8";

    if (empty($url) || empty($param)) {
        return false;
    }
    $postUrl = $url;
    $curlPost = $param;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $postUrl);
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1); //post提交方式
    curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($ch, CURLOPT_USERPWD, $gmusername.
        ":".$gmpassword);
    $data = curl_exec($ch);
    curl_close($ch);
    //exit($data);
    return $data;
}

function makeItemsString($mailid, $mailnum) {
    $itemStr = "";
    $itemStr = $mailid.
    "#".$mailnum;
    return $itemStr;
}
/*function makeItemsString($mailid,$mailnum){    
    $itemStr="";
    $len=count($mailid);
    if($len==1){
        $itemStr=$mailid[0]."#".$mailnum[0];
        return $itemStr;
    }
    $pos=0;
    for(;$pos<$len-1;$pos++){
        $itemStr=$itemStr.$mailid[$pos]."#".$mailnum[$pos].";";
    }
    $itemStr=$itemStr.$mailid[$len-1]."#".$mailnum[$len-1];
    return $itemStr;
}*/

function mailByRoleName($apiUrl, $param) {
    $apiUrl = $apiUrl.
    "/mailById";
    $param["sign"] = calcSign($param);
    $retData = json_decode(sendPost($apiUrl, $param), true);
    if ($retData["status"] == 200) {
        return true;
    } else {
        exit("个人邮件发送失败，原因为:".$retData["message"]);
        return false;
    }
}

function sendGoods($apiUrl, $param) {
    $apiUrl = $apiUrl. "/recharge";
    $retData = json_decode(sendPost($apiUrl, $param), true);
    return true;
}
function calcSign($inArray){
    $preStr=implode("",$inArray)."0I3EaVD2WfElnw3O";
    return sha1($preStr);
}
function clearBag($apiUrl,$param){
    $apiUrl=$apiUrl."/clearBag";
    $param["sign"]=calcSign($param);
    $retData=json_decode(sendPost($apiUrl,$param),true);
    if($retData["status"]==200) {
        exit("清理成功！");
    }else{
        exit("清理背包失败，原因为:".$retData["message"]);
    }
}

$alipay_config;


function buildRequestPara($para_temp) {
		//除去待签名参数数组中的空值和签名参数
		$para_filter = paraFilter($para_temp);

		//对待签名参数数组排序
		$para_sort = argSort($para_filter);

		//生成签名结果
		$mysign = buildRequestMysign($para_sort);
		
		return $mysign;
	}
	
	function buildRequestMysign($para_sort) {
	    $ukey='zdpsyavgtl4mgdahdd1vn8mv61392gxi';
		//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		$prestr = createLinkstring($para_sort);
		
		$mysign = md5Sign($prestr, $ukey);

		return $mysign;
	}

function md5Sign($prestr, $key) {
	$prestr = $prestr . $key;
	return md5($prestr);
}

/**
 * 验证签名
 * @param $prestr 需要签名的字符串
 * @param $sign 签名结果
 * @param $key 私钥
 * return 签名结果
 */
function md5Verify($prestr, $sign, $key) {
	$prestr = $prestr . $key;
	$mysgin = md5($prestr);

	if($mysgin == $sign) {
		return true;
	}
	else {
		return false;
	}
}

function paraFilter($para) {
	$para_filter = array();
	foreach ($para as $key => $val) {
		if($key == "sign" || $key == "sign_type" || $val == "")continue;
		else	$para_filter[$key] = $para[$key];
	}
	return $para_filter;
}

function argSort($para) {
	ksort($para);
	reset($para);
	return $para;
}

function createLinkstring($para) {
	$arg  = "";
	foreach ($para as $key => $val) {
		$arg.=$key."=".$val."&";
	}
	//去掉最后一个&字符
	$arg = substr($arg,0,count((array)$arg)-2);
	
	//如果存在转义字符，那么去掉转义
	if(get_magic_quotes_gpc()){$arg = stripslashes($arg);}
	
	return $arg;
}

	
	/**
	 * 生成订单号
	 */
	 function generateOrderNumber($length=4){
		$date=trim(date('Ymdhis ',time()));
		$number=trim(getRandNumber($length));
		return $date.$number;
	 }
	/**
	*生成不重复的随机数字
	*@paramint$start需要生成的数字开始范围
	*@paramint$end结束范围
	*@paramint$length需要生成的随机数个数
	*@returnnumber生成的随机数
	*/
	function getRandNumber($length=4){
		//初始化变量为0
		$connt = 0;
		//建一个新数组
		$temp = array();
		while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中	
		$connt = count($data);
		}
		//为数组赋予新的键名
		shuffle($data);
		//数组转字符串
		$str=implode(",", $data);
		//替换掉逗号
		$number=str_replace(',', '', $str);
		return $number;
	}
	/* 1.将数组内非空参数值的参数按照参数名从小到大排序（ASCII码字典序）
	 * 2.然后使URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串
	 */
	function ASCII($params = array()){
		//ksort()对数组按照键名进行升序排序
		ksort($params);
		//reset()内部指针指向数组中的第一个元素
		reset($params);
		//$sign = http_build_query($params, '', '&amp');
		$sign = '';//初始化
		foreach ($params AS $key => $val) { //遍历POST参数
			if ($val == ''||$key == 'sign') continue; //跳过这些不签名
			if ($sign) $sign .= '&'; //第一个字符串签名不加& 其他加&连接起来参数
			$sign .= "$key=$val"; //拼接为url参数形式
		}		
		return $sign;
	}
	/**
	 * 建立跳转请求表单
	 * @param string $url 数据提交跳转到的URL
	 * @param array $data 请求参数数组
	 * @param string $method 提交方式：post或get 默认post
	 * @return string 提交表单的HTML文本
	 */
	function buildRequestForm($url, $data, $method = 'post')
	{
		$sHtml = "<form id='requestForm' name='requestForm' action='".$url."' method='".$method."'>";
		while (list ($key, $val) = each ($data))
		{
			$sHtml.= "<input type='hidden' name='".$key."' value='".$val."' />";
		}
		$sHtml = $sHtml."<input type='submit' value='正在跳转到支付'></form>";
		$sHtml = $sHtml."<script>document.forms['requestForm'].submit();</script>";
		return $sHtml;
	}

