﻿<!--#include file="../pay_config.asp"-->
<!--#include file="pay_core.function.asp"-->
<!--#include file="pay_md5.function.asp"-->
<%
'/**
' * 三七云 https://37yz.com/
' * 功能：各接口请求提交类
' * 详细：构造各接口表单HTML文本，获取远程HTTP数据
' * 版本：1.0
' * 日期：2020-01-01
' * 说明：
' * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
' * 该代码仅供学习和研究聚合支付接口使用，只是提供一个参考。
' */

Class PaySubmit

	'初始构造函数
	Private Sub class_initialize()
	End Sub

	'类注销的时候自动执行的代码
    Private Sub Class_Terminate

    End Sub

	'/**
	'     * 生成要请求给支付平台的参数数组
	'     * @param $para_temp 请求前的参数数组
	'     * @return 要请求的参数数组
	'     */
	Private Function buildRequestPara(sParaTemp)
		Dim mysign

		'//除去待签名参数数组中的空值和签名参数
		Set para_filter=FilterPara(sParaTemp)

		'//对待签名参数数组排序
		Set para_sort = argSort(para_filter)

		'//获得签名结果
		mysign = BuildRequestMysign(para_sort)
	
		'/提交签名数组字符串（测试）
		para_sort.Add "signArray", CreateLinkString(para_sort)
		'//签名结果与签名方式加入请求提交参数组中
		para_sort.Add "sign", mysign

		Set sParaTemp=nothing
		Set para_filter=Nothing
		
		Set buildRequestPara= para_sort
	End Function 

	Private Function buildRequestPara_forarr(sParaTemp)
		Dim mysign
		'//待签名请求参数数组
		'//除去待签名参数数组中的空值和签名参数
		para_filter=FilterPara(sParaTemp)

		'//对待签名参数数组排序
		para_sort = argSort(para_filter)

		'//获得签名结果
		mysign = BuildRequestMysign(para_sort)

		'//签名结果与签名方式加入请求提交参数组中
		Set dict_para_sort=Dictionary_FromArray2d(para_sort)
		dict_para_sort.Add "sign", mysign
		dict_para_sort.Add "sign_type", Config_sign_type
		Set buildRequestPara_forarr= dict_para_sort
	End Function 



	'	/**
	'    * 生成要请求给支付平台的参数数组
	'    * @param $para_temp 请求前的参数数组
	'    * @return 要请求的参数数组字符串
	'    */

	Private Function buildRequestParaToString(sParaTemp)
			Dim strRequestData,sPara
			'//待签名请求参数数组
			sPara = BuildRequestPara(sParaTemp)

			'//把参数组中所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串，并对参数值做urlencode
			strRequestData = CreateLinkStringUrlencode(sPara)

			buildRequestParaToString= strRequestData
	End Function 

	'/**
	' * 建立请求，以表单HTML形式构造（默认）
	' * @param $para_temp 请求参数数组
	' * @param $method 提交方式。两个值可选：post、get
	' * @param $button_name 确认按钮显示文字
	' * @return 提交表单HTML文本
	' */
	Public Function buildRequestForm(sParaTemp, method, button_name) 
			'Response.Addheader "Content-Type","text/html; charset=gb2312"
			Dim sHtml,dicPara,url
			url=Config_apiurl&"?charset="&trim(Config_charset)
			'//待请求参数数组
			'On Error Resume Next
			Set dicPara = BuildRequestPara(sParaTemp)
			keys = dicPara.keys()
			For Each k In keys
				if k="account" then
					sHtml = sHtml& k & "=" & dicPara(k)
				else
					sHtml = sHtml&"&"& k & "=" & dicPara(k)
				end if
			Next

			Dim jsonString
			jsonString=PostHTTPPage(url,sHtml)

			Set obj = parseJSON(jsonString)
			if obj.code_img="" or IsEmpty(obj.code_img) then
				dim arr2(2)
				arr2(0)="error"
				arr2(1)=jsonString
				buildRequestForm=arr2
			else
			    '//返回给pay.asp页面的数据
				dim arr(5)
				arr(0)="ok"
				arr(1)=obj.pay_no
				arr(2)=obj.pay_money
				arr(3)=obj.code_img
				arr(4)=dicPara("subject")
				buildRequestForm=arr
				'For i = Lbound(arr) to Ubound(arr)
				''	Response.Write arr(i) & "<br>"
				'Next
				'response.end
			end if
			Set dicPara=nothing
	End function

	Public function PostHTTPPage(url,data) 
		dim Http 
		set Http=server.createobject("MSXML2.SERVERXMLHTTP.3.0")
		Http.open "POST",url,false 
		Http.setRequestHeader "CONTENT-TYPE", "application/x-www-form-urlencoded" 
		Http.send(data) 
		if Http.readystate<>4 then 
		exit function 
		End if
		PostHTTPPage=bytesToBSTR(Http.responseBody,"utf-8") 
		set http=nothing 
		if err.number<>0 then err.Clear 
	End function

	'/**
	' * 生成签名结果
	' * @param $para_sort 已排序要签名的数组
	' * return 签名结果字符串
	' */
	Private Function buildRequestMysign(ByVal para_sort)
		Dim prestr,mysign

		'//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
		prestr = CreateLinkString(para_sort)

		'获得签名结果
		 mysign = md5Sign(prestr,Config_appkey)
		 Set para_sort=nothing
		 buildRequestMysign= mysign
	End Function 

	'/**
	' * 用于防钓鱼，调用接口query_timestamp来获取时间戳的处理函数
	' * 注意：该功能PHP5环境及以上支持，因此必须服务器、本地电脑中装有支持DOMDocument、SSL的PHP配置环境。建议本地调试时使用PHP开发软件
	' * return 时间戳字符串
	' */
	Public Function query_timestamp()
		url = Config_apiurl&"service=query_timestamp"&"&charset="&trim(Config_charset)
		sXml=getHttpResponseGET(url,Trim(Config_charset))

		encrypt_key = ""	
		Set xmlDoc = Server.CreateObject("MSXML2.DOMDocument")
		xmlDoc.setProperty "SelectionLanguage","XPath"
		xmlDoc.Async = False
		If xmlDoc.loadxml(sXml) Then
			set xNode= xmlDoc.selectSingleNode("/alipay/response/timestamp/encrypt_key")
			query_timestamp=xNode.text
		else
			query_timestamp=""
		end If
		set xNode= nothing
		Set xmlDoc=nothing
	End function
End Class
%>