<?php
require 'config.php';
require "Des.php";
///////////////////////////////////////////////
//下面代码基本不需要修改
if (empty($_POST)) $_POST = $_GET;  //如果为GET方式访问
if(version_compare(PHP_VERSION,'5.4.0','<')){
	outputError('PHP版本要求大于5.4.0');
}
if(!isset($_POST['appid'])){
	outputError('参数非法');
}
//验证商户号
if($_POST['appid']!=$appid){
	outputError('商户编号不正确');
}
if (!function_exists('openssl_encrypt')){
	outputError('请开启php.ini的openssl扩展');
}
//解密接口参数
$des = new Des();
$parameter=$_POST['parameter'];
$decode=$des->decrypt($parameter,$deskey);
if(empty($decode)){
	outputError('算法密钥不正确');
}
parse_str($decode, $data);
//验证商户密钥
if($appkey!=$data['appkey']){
	outputError('商户密钥不正确');
}

//开始充值
chongzhi($data);
function chongzhi($data){
	//全局变量，函数内调用需要加global声明
	global $taocan;
	try{
		$account = $data['account'];
		$money = $data['money'];
		if(isset($data['param'])){
		    $param = $data['param'];
		    if(!isset($taocan[$param])){
    			outputError("套餐不存在");
    		}
    		if($taocan[$param][0]<>$money){
    			outputError("充值金额跟套餐价格不一致");
    		}
		}else{
		    //通过金额获取套餐ID
		    foreach($taocan as $k=>$d){
		        if($d[0]==intval($money)){
		            $param=$k;
		            break;
		        }
		    }
		    if(empty($param)){
		        outputError("不存在金额为".$money."的套餐");
		    }
		}
		
		$czurl = "http://127.0.0.1:10003/paycb";
		$data = array(
				"playerId" => $account,
				"productId" => $param,
		);
		$result = request_post($czurl,$data);
		if($result=='SUCCESS'){
			//成功后返回
			$gold = $taocan[$param][1];
			$msg = sprintf("账号[%s]成功充值金额%s元，获得%s",$account,$money,$gold);
			outputSuccess($msg);
		}else{
			outputError("充值失败，错误代码：".$result);
		}
	} catch (\Exception $e) {
		outputError('充值异常，Error：'.$e->getMessage());
	}
}

function request_post($url = '', $post_data = array()) {
    if (empty($url) || empty($post_data)) {
        return false;
    }
    $o = "";
    foreach ( $post_data as $k => $v ) { 
        $o.= "$k=" . $v . "&" ;
    }
    $post_data = substr($o,0,-1);
    $postUrl = $url;
    $curlPost = $post_data;
    $ch = curl_init();//初始化curl
    curl_setopt($ch, CURLOPT_URL,$postUrl);//抓取指定网页
    curl_setopt($ch, CURLOPT_HEADER, 0);//设置header
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: text/plain; charset=utf-8'
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);//要求结果为字符串且输出到屏幕上
    curl_setopt($ch, CURLOPT_POST, 1);//post提交方式
    curl_setopt($ch, CURLOPT_POSTFIELDS, $curlPost);
    $data = curl_exec($ch);//运行curl
    curl_close($ch);
    return $data;
}

function outputError($msg){
	$arr=array('code'=>0,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

function outputSuccess($msg){
	$arr=array('code'=>1,'msg'=>$msg);
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

/** 
 * 打印日志
 * $msg 日志内容
 */
function printLog($msg) {
	if (!is_dir('log')){
		mkdir('log',0777,true);
	}
	$path="log/".date('Y-m-d').".log";
	file_put_contents($path, "【" . date('Y-m-d H:i:s') . "】" . $msg . "\r\n\r\n", FILE_APPEND);
}