﻿<%
'/* *
' * 支付平台接口公用函数
' * 详细：该类是请求、通知返回两个文件所调用的公用函数核心处理文件
' * 版本：1.0
' * 修改日期：2018-03-08
' * 说明：
' * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
' * 该代码仅供学习和研究支付平台使用，只是提供一个参考。
' */

'/**获取表单数据里的值
' * @param FormData 二进制的表单数据
' * @param FormName  键名
' */
Function GetFormVal(FormData,FormName)
	'Chr返回一个Unicode字符，2个字节
	'ChrB返回一个ANSI字符，1个字节
	charBs = ChrB(13) & ChrB(10)
	Divider = LeftB(FormData, InStrB(FormData, charBs) - 1)
	GetFormVal = ""
	StartPos = LenB(Divider) + 2
	FormName = Chr(34) & FormName & Chr(34)
	Do While StartPos > 0
	strlen = InStrB(StartPos, FormData, charBs) - StartPos
	SearchStr = MidB(FormData, StartPos, strlen)
	If InStr(binTostr(SearchStr,"utf-8"), FormName) > 0 Then
		ValStart = InStrB(StartPos, FormData, charBs & charBs) + 4
		ValLen = InStrB(StartPos, FormData, Divider) - 2 - ValStart
		ValContent = MidB(FormData, ValStart, ValLen)
		If GetFormVal <> "" Then
			GetFormVal = GetFormVal & "," & binTostr(ValContent,"utf-8")
		Else
			'二进制转化
			GetFormVal = binTostr(ValContent,"utf-8")
		End If
	End If
	If InStrB(StartPos, FormData, Divider) < 1 Then
	Exit Do
	End If
	StartPos = InStrB(StartPos, FormData, Divider) + LenB(Divider) + 2
	Loop
End Function

'/**获取表单数据
' * @param FormData 二进制的表单数据
' * @return 返回键值对格式的数组
' */
Function GetFormData(FormData)
	'Chr返回一个Unicode字符，2个字节
	'ChrB返回一个ANSI字符，1个字节
	charBs = ChrB(13) & ChrB(10)
	Divider = LeftB(FormData, InStrB(FormData, charBs) - 1)
	StartPos = LenB(Divider) + 2
	'创建对象数组
	Set dataArray = Server.CreateObject("Scripting.Dictionary")  ' Server.CreateObject("Scripting.Dictionary")
	Do While StartPos > 0
		strlen = InStrB(StartPos, FormData, charBs) - StartPos
		SearchStr = MidB(FormData, StartPos, strlen)
		'1.获取单个表单元素属性，如：Content-Disposition: form-data; name="键名"
		FormItem=binTostr(SearchStr,"utf-8")
		'2.获取键名
		FormName=Right(FormItem,Len(FormItem)-Instr(FormItem,"="))
		'3.去掉键名的双引号
		FormName = Replace(FormName, """", "")
		FormValue=""
		If FormName <> "" Then
			ValStart = InStrB(StartPos, FormData, charBs & charBs) + 4
			ValLen = InStrB(StartPos, FormData, Divider) - 2 - ValStart
			ValContent = MidB(FormData, ValStart, ValLen)
			If FormValue <> "" Then
				FormValue = FormValue & "," & binTostr(ValContent,"utf-8")			
			Else
				'二进制转化
				FormValue = binTostr(ValContent,"utf-8")
			End If
			'添加元素到数组中
			dataArray.Add FormName, FormValue
		End If		
		If InStrB(StartPos, FormData, Divider) < 1 Then
			Exit Do
		End If
		StartPos = InStrB(StartPos, FormData, Divider) + LenB(Divider) + 2
	Loop
	Set GetFormData=dataArray
	Set dataArray=nothing
End Function

'/**二进制转化（将二进制转换为字符串）
' * @param vin 要转换的二进制
' * @param charset 编码方式 utf-8或者gb2312
' */
Function binTostr(vin,charset) 
    Const adTypeText = 2 
    Dim BytesStream,StringReturn 
    Set BytesStream = Server.CreateObject("ADODB.Stream") 
	With BytesStream 
		.Type = adTypeText 
		.Open 
		.WriteText vin 
		.Position = 0 
		.Charset = charset
		.Position = 2 
		StringReturn = .ReadText 
		.Close 
	End With 
	Set BytesStream = Nothing 
	binTostr = StringReturn
End Function


'/**解析json字符串
' * @param str json字符串
' */

Function parseJSON(str)
	Dim scriptCtrl
    If Not IsObject(scriptCtrl) Then
        Set scriptCtrl = Server.CreateObject("MSScriptControl.ScriptControl")
        scriptCtrl.Language = "JScript"
        scriptCtrl.AddCode "Array.prototype.get = function(x) { return this[x]; }; var result = null;"
    End If
	scriptCtrl.ExecuteStatement "result = " & str & ";"
    Set parseJSON = scriptCtrl.CodeObject.result
	set scriptCtrl = nothing
End Function


' * 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
' * @param $para 需要拼接的数组
' * return 拼接完成以后的字符串
' */
function createLinkstring(ByVal dicArray)
	Dim prestr
	prestr=""
	keys = dicArray.keys()
	For Each k In keys
		prestr = prestr&k&"="&dicArray(k)&"&"
	Next
	'//去掉最后一个&字符
	prestr=left(prestr,len(prestr)-1) 
	createLinkstring=prestr
	Set dicArray=nothing
End Function 


'/**
' * 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串，并对字符串做urlencode编码
' * @param $para 需要拼接的数组
' * return 拼接完成以后的字符串
' */
function createLinkstringUrlencode(dicArray) 
	Dim prestr
	prestr=""
	keys = dicArray.keys()
	For Each k In keys
		prestr = prestr&k&"="&server.URLEncode(dicArray(k))&"&"
	Next
	'//去掉最后一个&字符
	prestr=left(prestr,len(prestr)-1) 
	createLinkstringUrlencode=prestr
End function

'/**
' * 除去数组中的空值和签名参数
' * @param $para 签名参数组
' * return 去掉空值与签名参数后的新签名参数组
' */
function FilterPara(dicArrayPre)
	Set dicArray = Server.CreateObject("Scripting.Dictionary")  ' Server.CreateObject("Scripting.Dictionary")
	keys = dicArrayPre.keys()

	mysign=""
	'组合签名字符串
	For Each k In keys
		If ( (LCase(k) <> "sign") And (LCase(k) <> "sign_type") And (dicArrayPre(k)<>"") And (isnull(dicArrayPre(k)) = false) ) Then
			dicArray.Add k, dicArrayPre(k)
		End if
	Next

	Set FilterPara= dicArray
	Set dicArray=nothing
End Function 

'/**
' * 对数组排序
' * @param $para 排序前的数组
' * return 排序后的数组
' */
function argSort(ByVal para) 
	keys = para.keys()
	Set sortArray = Server.CreateObject("Scripting.Dictionary")  ' Server.CreateObject("Scripting.Dictionary")
	'按字母顺序排序
	For i = 0 To ubound(keys) - 1
		For j = i + 1 To UBound(keys)
			If StrComp(keys(i), keys(j)) > 0 Then
				tmp = keys(i)
				keys(i) = keys(j)
				keys(j) = tmp
			End If
		Next
	Next

	For Each k In keys
		sortArray.add k,para(k)
	Next
	Set para = Nothing
	Set argSort=sortArray
End Function

'/**
' * 写入日志到txt文本
' * sWord 日志内容
' *
Function LogResult(sWord)
	txtpath = Server.MapPath("log/"&FormatDate(Now(),2)&".txt")
    Set fso = Server.CreateObject("Scripting.FileSystemobject")
	' 判断文件是否存在，不存在就创建
    if  fso.FileExists(txtpath)=false then fso.CreateTextFile(txtpath) End if
    set cnrs = fso.OpenTextFile(txtpath,8)
		content= FormatDate(Now(),1)&" "&sWord
        cnrs.WriteLine(content)
        cnrs.Close 
   set cnrs = nothing 
   set fso = nothing 
End Function

'/**
' * 日期格式化
' * DateAndTime 时间戳
' * datetype    显示的日期类型，1为2021-01-13 12:01:15
' *
Function FormatDate(DateAndTime, datetype)
	On Error Resume Next
    Dim y, m, d, h, mi, s, strDateTime
	If Not IsNumeric(datetype) Then Exit Function
	If Not IsDate(DateAndTime) Then Exit Function 
    y = CStr(Year(DateAndTime)) 
    m = CStr(Month(DateAndTime)) 
    If Len(m) = 1 Then m = "0" & m 
    d = CStr(Day(DateAndTime)) 
    If Len(d) = 1 Then d = "0" & d 
    h = CStr(Hour(DateAndTime)) 
    If Len(h) = 1 Then h = "0" & h 
    mi = CStr(Minute(DateAndTime)) 
    If Len(mi) = 1 Then mi = "0" & mi 
    s = CStr(Second(DateAndTime)) 
    If Len(s) = 1 Then s = "0" & s 
    Select Case datetype 
    Case "1" 
        strDateTime = y & "-" & m & "-" & d & " " & h & ":" & mi & ":" & s 
    Case "2" 
        strDateTime = y & "-" & m & "-" & d 
    Case "3" 
        strDateTime = y & "/" & m & "/" & d 
    Case "4" 
        strDateTime = y & "年" & m & "月" & d & "日" 
    Case "5" 
        strDateTime = m & "-" & d & " " & h & ":" & mi 
    Case "6" 
        strDateTime = m & "/" & d 
    Case "7" 
        strDateTime = m & "月" & d & "日" 
    Case "8" 
        strDateTime = y & "年" & m & "月" 
    Case "9" 
        strDateTime = y & "-" & m 
    Case "10" 
        strDateTime = y & "/" & m 
    Case "11" 
        strDateTime = right(y,2) & "-" &m & "-" & d & " " & h & ":" & mi 
    Case "12" 
        strDateTime = right(y,2) & "-" &m & "-" & d 
    Case "13" 
        strDateTime = m & "-" & d 
    Case Else 
        strDateTime = DateAndTime 
    End Select 
    FormatDate = strDateTime
End Function

'/**
' * 字典对象转为二维数组
' * @param dict 字典对象
' * return 二维数组
' */
Function Array2d_FromDictionary(dict)
    Dim a 
    Dim i 
    Dim k 
     
    redim a(dict.count - 1,1) 
     
    i = 0 
    for each k in dict.keys 
        a(i,0) = k 
        a(i,1) = dict(k) 
        i = i + 1 
    next 
     
    Array2d_FromDictionary = a 
   
End Function

'/**
' * 二维数组-->字典对象
' * @param v_array 二维数组
' * return 字典对象
' */
function Dictionary_FromArray2d(v_array)
	Set sortArray = Server.CreateObject("Scripting.Dictionary")  ' Server.CreateObject("Scripting.Dictionary")
	for n=0 to ubound(v_array)
		k=v_array(n,0)
		v=v_array(n,1)
		sortArray.add k,v
	next
	set Dictionary_FromArray2d=sortArray
end function 

'//处理编码
Function BytesToBstr(body,Cset)
Dim objstream
Set objstream = Server.CreateObject("adodb.stream")
	objstream.Type = 1
	objstream.Mode =3
	objstream.Open
	objstream.Write body
	objstream.Position = 0
	objstream.Type = 2
	objstream.Charset = Cset
	BytesToBstr = objstream.ReadText
	objstream.Close()
Set objstream = Nothing
End Function

''
' 获取远程服务器ATN结果
' param notify_id 通知校验ID
' return 服务器ATN结果字符串
Function getHttpResponseGET(v_Url,v_cset)
	Dim objHttp,sResponseTxt
	Set objHttp = Server.CreateObject("Msxml2.ServerXMLHTTP.3.0")
	objHttp.setOption 2, 13056
	objHttp.open "GET", v_Url, False
	objHttp.send()
	sResponseTxt = BytesToBstr(objHttp.ResponseBody,v_cset)
	Set objHttp = Nothing

	getHttpResponseGET = sResponseTxt
End Function 

Function getHttpResponsePost(v_Url,v_cset)
	Dim objHttp,sResponseTxt
	Set objHttp = Server.CreateObject("Msxml2.ServerXMLHTTP.3.0")
	objHttp.setOption 2, 13056
	objHttp.open "POST", v_Url, False
	objHttp.send()
	sResponseTxt = BytesToBstr(objHttp.ResponseBody,v_cset)
	Set objHttp = Nothing

	getHttpResponseGET = sResponseTxt
End Function 


%>