<?php
/*
 * 三七云 https://www.37yz.com
 * Date: 2020/12/10
 * Time: 15:38
 * 说明：
 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
 * 该代码仅供学习和研究接口使用，只是提供一个参考，最终解释权归美奇软件开发工作室所有。
 * 严禁一切钓鱼、色情、赌博、私彩及违反国家法律法规等使用。
 * 注意：
 * UTF-8编码不要在记事本下编辑，否则会出现一些奇葩的问题，正确方法应在开发工具里打开编辑
 */
ini_set("error_reporting","E_ALL & ~E_NOTICE");
//仙玉充值比例
$bili_xianyu = 50;
//元宝充值比例
$bili_yuanbao = 500;
//商户编号
$appid = '填写商户编号';
//商户密钥
$appkey = '填写商户密钥';
//接口地址
$payurl = 'http://www.37yz.com/pay.html';
//异步通知地址
$notify_url = "http://您的网站地址/pay/pay_notify.php";
//页面跳转同步通知页面路径
$return_url = "http://您的网站地址/pay/pay_return.php";
//商城回调地址
$shop_notify_url = "http://您的网站地址/pay/shop_notify.php";

function generateOrderNumber($length=4) {
	$date=trim(date('Ymdhis ',time()));
	$number=trim(getRandNumber($length));
	return $date.$number;
}

function getRandNumber($length=4) {
	//初始化变量为0
	$connt = 0;
	//建一个新数组
	$temp = array();
	while($connt < $length) {
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中
		$connt = count($data);
	}
	//为数组赋予新的键名
	shuffle($data);
	//数组转字符串
	$str=implode(",", $data);
	//替换掉逗号
	$number=str_replace(',', '', $str);
	return $number;
}

function generateSign($params,$appkey) {
    //ksort()对数组按照键名进行升序排序
	ksort($params);
	//reset()内部指针指向数组中的第一个元素
	reset($params);
	//$sign = http_build_query($params, '', '&amp');
	$sign = ''; //初始化
	foreach ($params AS $key => $val) { //遍历POST参数
		if ($val == '' || $key == 'sign'|| $key == 'sign_type' || $key == 'signArray') continue; //跳过这些不签名
		if ($sign) $sign.= '&'; //第一个字符串签名不加& 其他加&连接起来参数
		$sign.= "$key=$val"; //拼接为url参数形式      
	}
	//拼接商户密钥，然后md5加密
	$stringTemp = md5($sign.$appkey);
}

function buildRequestForm($url, $params, $method = 'post') {
	$sHtml = "<form id='requestForm' name='requestForm' action='".$url."' method='".$method."'>";
	foreach($params as $key=>$val){
		$sHtml.= "<input type='hidden' name='".$key."' value='".$val."' />";
	}
	$sHtml = $sHtml."<input type='submit' value='正在跳转到支付'></form>";
	$sHtml = $sHtml."<script>document.forms['requestForm'].submit();</script>";
	return $sHtml;
}
function get_real_ip(){
    $ip=FALSE;
    //客户端IP 或 NONE
    if(!empty($_SERVER["HTTP_CLIENT_IP"])){
        $ip = $_SERVER["HTTP_CLIENT_IP"];
    }
    //多重代理服务器下的客户端真实IP地址（可能伪造）,如果没有使用代理，此字段为空
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode (", ", $_SERVER['HTTP_X_FORWARDED_FOR']);
        if ($ip) { array_unshift($ips, $ip); $ip = FALSE; }
        for ($i = 0; $i < count($ips); $i++) {
            if (!eregi ("^(10│172.16│192.168).", $ips[$i])) {
                $ip = $ips[$i];
                break;
            }
        }
    }
    //客户端IP 或 (最后一个)代理服务器 IP
    return ($ip ? $ip : $_SERVER['REMOTE_ADDR']);
}
function outputError($msg){
	$arr=array('code'=>0,'msg'=>$msg);
	header('Content-Type:application/json; charset=utf-8');
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}

function outputSuccess($msg){
	$arr=array('code'=>1,'msg'=>$msg);
	header('Content-Type:application/json; charset=utf-8');
	echo json_encode($arr, JSON_UNESCAPED_UNICODE);
	exit;
}
//输出Json
function outputJson($data, $data_count = null) {
    $arr['code'] = 1;
    $arr['msg'] = 'success';
    $arr['count'] = ($data_count == null ? count($data) : $data_count);
    $arr['data'] = $data;
    header('Content-Type:application/json; charset=utf-8');
    echo json_encode($arr, JSON_UNESCAPED_UNICODE);
    exit;
}
function printLog($msg) {
	if (!is_dir('log')){
		mkdir('log',0777,true);
	}
	$path="log/".date('Y-m-d').".log";
	file_put_contents($path, "【" . date('Y-m-d H:i:s') . "】" . $msg . "\r\n\r\n", FILE_APPEND);
}
?>