<?php
namespace app\api\controller;

class Pay extends \think\Controller{
    
	protected $view;
	protected $noNeedLogin = ["index", "pay", "paysubmit", "callbackurl", "notifyurl"];
	protected $noNeedRight = "*";
	public function _initialize()
	{
		parent::_initialize();
		if (!\think\Config::get("fastadmin.usercenter")) {
			$this->error(__("User center already closed"));
		}
	}
	public function __construct()
	{
		parent::__construct();
		$this->view = new \think\View();
	}
	public function index()
	{
	    $data = input("");
		$account = trim($data["account"]);
		$user = \think\Db::name("user")->where("username", $account)->find();
		if (!$user) {
			return "账号不存在";
		}
		$this->view->assign(["account"=>$account,"agent"=> $user["agent"]]);
    	return $this->view->fetch();
	}
	public function submit(){
	    $data = input("post.");
	    $account = trim($data["account"]);
	    $agent = trim($data["agent"]);
	    $money = trim($data["money"]);
		$contact = trim($data["contact"]);
		$type = intval($data["type"]);
		$domain = \think\Request::instance()->domain();
		$user = \think\Db::name("user")->where("username", $account)->find();
		if (!$user) {
			return "账号不存在";
		}
		//订单写入数据库
		$out_trade_no = $this->generateOrderNumber();
		$gold = $money * 100;
		$ticket = $account . "在线充值" . $gold . "万灵币";
		$ip = \think\Request::instance()->ip();
		$data = [
		    "payagent" => $agent,
		    "out_trade_no" => $out_trade_no,
		    "mode" => $type, 
		    "user" => $account, 
		    "money" => $money, 
		    "gold" => $gold, 
		    "time" => time(), 
		    "ticket" => $ticket, 
		    "ip" => $ip, 
		    "result" => "未支付"
		];
		$result = \think\Db::name("pay")->insert($data, true);
		if(!$result){
		    return  "<script>alert('充值失败');type='text/javascript'>history.go(-1);</script>";exit;
		}
		/*------------------------------------ 提交到三七云平台 -------------------------------------*/
    	try {
    		//计算签名
    		$postData=array(
    		    "appid" => \think\Config::get("payconfig.pid"),
    		    "payid" => $out_trade_no,//订单号
    		    "money" => $money,//提交金额
    		    "type" => $type,//支付方式 1：支付宝  2：微信支付
    		    "notify_url" => $domain . "/api/pay/notifyurl",
    		    "return_url" => $domain . "/api/pay/callbackurl",
    		    "subject" => $account, 
    		    "param" => $account,//账号放自定义参数里
    		    "contact" => $contact, //联系方式
				"codesize" => 150,
    		);

    		$stringTemp = $this->ASCII($postData);
    		$postData["sign"] =	$this->md5Sign($stringTemp,\think\Config::get("payconfig.key"));
    		//4.跳转到支付页面
    		$res = $this->buildRequestForm(\think\Config::get("payconfig.url"),$postData);
    		echo $res;
    		exit;
    	}catch (\Exception $e) {
    	    printLog($e);
    		return  "<script>alert('充值异常');type='text/javascript'>history.go(-1);</script>";exit;
    	}
	}
	public function callbackurl()
	{
		if (empty($_POST)) $_POST = $_GET;//如果为GET方式访问
		$sign = $this->ASCII($_POST);
		$flag = $this->md5Verify($sign,$_POST['sign'],\think\Config::get("payconfig.key"));
		if($flag){
		    $pay_id = $_POST['pay_id'];              //需要充值的ID 或订单号 或用户名
    		$param = isset($_POST['param'])?$_POST['param']:'';//自定义参数
	    	$goback = "index?user=" . $param;
    		$this->view->assign("dingdan", $pay_id);
    		$this->view->assign("goback", $goback);
    		$this->view->assign("cache", $_POST);
    		return $this->view->fetch();
		}else{
		    exit("支付失败");
		}
		
	}
	public function notifyurl()
	{
	    if (empty($_POST)) $_POST = $_GET;//如果为GET方式访问
		$sign = $this->ASCII($_POST);
		$flag = $this->md5Verify($sign,$_POST['sign'],\think\Config::get("payconfig.key"));
		if($flag){
			$out_trade_no = $_POST['pay_id']; //需要充值的ID 或订单号 或用户名
			$money = (float)$_POST['pay_money']; //实际付款金额	
			$username = isset($_POST['param'])?$_POST['param']:'';//自定义参数
			if(empty($username)){
			    exit('自定义参数为空'); 
			}
			$trade_no = \think\Db::name("pay")->where("out_trade_no", $out_trade_no)->find();
			if ($trade_no) {
				if ($trade_no["result"] == "normal") {
					exit('订单重复'); 
				}
				$user = \think\Db::name("user")->where("username", $username)->find();
				if(empty($user)){
				    exit('账号不存在'); 
				}
				\think\Db::startTrans();
				try{
    			   	//充值比例：1元 = 100万灵币
			    	$newmoney = $user["money"] + $money * 100;
				    \think\Db::name("pay")->where("out_trade_no", $out_trade_no)->update(["result" => "normal"]);
				    \think\Db::name("user")->where("username", $username)->update(["money" => $newmoney]);
                    \think\Db::commit();
    				exit('success'); //返回成功，业务处理完成，下面不再执行了
    			} catch (\Exception $e) {
    			    \think\Db::rollback();
    				exit('充值失败');
    			}
			}else{
			    exit('订单不存在'); 
			}
		}else{
			exit('fail');//返回失败 继续补单
		}
	}
	/**
	 * 生成订单号
	 */
	 protected function generateOrderNumber($length=4){
		$date=trim(date('Ymdhis ',time()));
		$number=trim($this->getRandNumber($length));
		return $date.$number;
	 }
	/**
	*生成不重复的随机数字
	*@paramint$start需要生成的数字开始范围
	*@paramint$end结束范围
	*@paramint$length需要生成的随机数个数
	*@returnnumber生成的随机数
	*/
	protected function getRandNumber($length=4){
		//初始化变量为0
		$connt = 0;
		//建一个新数组
		$temp = array();
		while($connt < $length){
		//在一定范围内随机生成一个数放入数组中
		$temp[] = mt_rand(0, 9);
		//$data = array_unique($temp);
		//去除数组中的重复值用了“翻翻法”，就是用array_flip()把数组的key和value交换两次。这种做法比用 array_unique() 快得多。	
		$data = array_flip(array_flip($temp));
		//将数组的数量存入变量count中
		$connt = count($data);
		}
		//为数组赋予新的键名
		shuffle($data);
		//数组转字符串
		$str=implode(",", $data);
		//替换掉逗号
		$number=str_replace(',', '', $str);
		return $number;
	}
	/**
     * 签名字符串
     * @param $prestr 需要签名的字符串
     * @param $key 私钥
     * return 签名结果
     */
	protected function md5Sign($prestr, $key) {
		$prestr = $prestr . $key;
		return md5($prestr);
	}
	/**
     * 验证签名
     * @param $prestr 需要签名的字符串
     * @param $sign 签名结果
     * @param $key 私钥
     * return 签名结果
     */
	protected function md5Verify($prestr, $sign, $key) {
		$prestr = $prestr . $key;
		$mysgin = md5($prestr);
		if($mysgin == $sign) {
			return true;
		} else {
			return false;
		}
	}
	/* 1.将数组内非空参数值的参数按照参数名从小到大排序（ASCII码字典序）
	 * 2.然后使URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串
	 */
	protected function ASCII($params = array()){
		//ksort()对数组按照键名进行升序排序
		ksort($params);
		//reset()内部指针指向数组中的第一个元素
		reset($params);
		//$sign = http_build_query($params, '', '&amp');
		$sign = '';//初始化
		foreach ($params as $key => $val) { //遍历POST参数
			if ($val == ''||$key == 'sign') continue; //跳过这些不签名
			if ($sign) $sign .= '&'; //第一个字符串签名不加& 其他加&连接起来参数
			$sign .= "$key=$val"; //拼接为url参数形式
		}
		return $sign;
	}
	/**
	 * 建立跳转请求表单
	 * @param string $url 数据提交跳转到的URL
	 * @param array $data 请求参数数组
	 * @param string $method 提交方式：post或get 默认post
	 * @return string 提交表单的HTML文本
	 */
	protected function buildRequestForm($url, $data, $method = 'post')
	{
		$sHtml = "<form id='requestForm' name='requestForm' action='".$url."' method='".$method."'>";
		foreach ($data as $key => $val) {
			$sHtml.= "<input type='hidden' name='".$key."' value='".$val."' />";
		}
		$sHtml = $sHtml."<input type='submit' value='正在跳转到支付'></form>";
		$sHtml = $sHtml."<script>document.forms['requestForm'].submit();</script>";
		return $sHtml;
	}
}